import matplotlib.pyplot as plt
import seaborn as sns
import os
from sklearn.preprocessing import LabelEncoder
from sklearn.model_selection import train_test_split
from sklearn.metrics import classification_report, confusion_matrix
from sklearn.linear_model import LogisticRegression
from sklearn.metrics import accuracy_score
from sklearn.preprocessing import StandardScaler
from sklearn.cluster import KMeans
from sklearn.metrics import silhouette_score
import numpy as np
from scipy import stats
import sys
sys.path.append(sys.argv[1])

import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, assert_series, logical_or, to_list, fetch_index

atp_tennis = read_csv_file(os.path.join(sys.argv[1], 'atp_tennis.csv'))

# Filter the DataFrame
federer_matches = atp_tennis[logical_or(assert_series(atp_tennis['Player_1'], 'Federer R.', 'equality'), assert_series(atp_tennis['Player_2'], 'Federer R.', 'equality'))]

# Get the index using the custom function
federer_match_ids_index = fetch_index(federer_matches)

# Convert the index to a list
federer_match_ids = to_list(federer_match_ids_index)

print(federer_match_ids)
# pickle.dump(federer_match_ids,open("./ref_result/federer_match_ids.pkl","wb"))

import pandas as pd
import pickle
from decision_company import read_csv_file, fetch_column, logical_or, search_where, extract_unique_values, assert_series



# Find Federer matches
federer_matches = atp_tennis[logical_or(assert_series(atp_tennis['Player_1'], 'Federer R.', 'equality'), assert_series(atp_tennis['Player_2'], 'Federer R.', 'equality'))]

# Get Federer opponents
federer_opponents = extract_unique_values(search_where(fetch_column(federer_matches, 'Player_1'), assert_series(federer_matches['Player_1'], 'Federer R.', 'inequality'), federer_matches['Player_2'])) 

print(federer_opponents)
# pickle.dump(federer_opponents,open("./ref_result/federer_opponents.pkl","wb"))

